#!/usr/bin/perl
###########################################################################
#
#   (c) Markus Wolf, 1998-2002
#
###########################################################################
#
# env.cgi
# COPYRIGHT NOTICE                                                           
# Copyright 2002 Markus Wolf     
# All Rights Reserved.                     
# EMail: support@perlunity.de
# URL  : http://www.perlunity.de 
#                                                                            
# env.cgi darf von jedermann kostenlos benutzt und gendert werden, solange
# dieser Copyright-Verweis und die restlichen Kommentare erhalten bleiben. Mit
# dem Einsatz dieses Skripts akzeptieren Sie, da Markus Wolf von jeglicher
# Haftung und Gewhrleistung hinsichtlich des Einsatzes befreit ist.
# 
# Der Verkauf dieses Skripts, auch in modifizierter Form, ist ohne vorherige
# Absprache ausdrcklich untersagt.
# (Mit anderen Worten: Bitte fragen Sie mich, bevor Sie versuchen, mit meinem
# Skript Geld zu verdienen.)
# 
# Um dieses Skript ber das Internet oder irgendein anderes Medium
# weiterzuverbreiten, bentigen Sie vorher meine Erlaubnis. In jeden Fall
# mssen der Copyright-Verweis und die restlichen Kommentare erhalten bleiben.
#
###########################################################################
#
# Einfach ins CGI-Verzeichnis kopieren und direkt per Link ausfhren:
# http://www.meinserver.de/cgi-bin/env.cgi
# und auf dem Bildschirm wird Liste mit den Umgebungsvariablen und 
# deren Inhalt ausgegeben.
#
###########################################################################


###
#Module

use File::Find ;


###
#Puffer ausschalten

$|=1 ;


###
#Ausgabe an den Browser schicken

print "Content-type: text/html\n\n";

print qq~
<html>
<head>
<title>ENV-Viewer</title>
<style type="text/css">
<!--
   BODY { font-family:Verdana,Arial; font-size:11px;} 
   TD { font-family:Verdana,Arial; font-size:11px; } 
   A:hover {color: #990000}
-->
</style>
</head>
<body bgcolor="#FFFFFF" text="#000000" link="#000000" vlink="#000000" alink="#000000">
~ ;


###
#ENV-Liste mit den Bezeichnungen und Inhalten ausdrucken

my $version=`perl -v` ;

print qq~
<table border=1 cellspacing=0 cellpadding=2  width=100%>
<tr bgcolor=#b6d5e3><td colspan=3><b>Liste der Umgebungsvariablen</b></td></tr>
<tr><td>Perl-Var \$0</td><td>&nbsp;&nbsp;=&gt;&nbsp;&nbsp;</td><td>$0</td></tr>
<tr><td>Perl-Var \$\$</td><td>&nbsp;&nbsp;=&gt;&nbsp;&nbsp;</td><td>$$</td></tr>
<tr><td>Perl-Var \$^O</td><td>&nbsp;&nbsp;=&gt;&nbsp;&nbsp;</td><td>$^O</td></tr>
<tr><td valign=top>Perl-Var \$^V</td><td valign=top>&nbsp;&nbsp;=&gt;&nbsp;&nbsp;</td><td>$version</td></tr>
<tr><td colspan=3>&nbsp;</td></tr>
~ ;

foreach my $e_v_n (sort keys %ENV) {

    print "<tr><td>$e_v_n</td><td>&nbsp;&nbsp;=&gt;&nbsp;&nbsp;</td><td>$ENV{$e_v_n}&nbsp;</td></tr>";
}

print qq(<tr><td colspan=3>&nbsp;</td></tr>) ;

foreach my $path (@INC) {
	
	$inc .= "$path <BR>\n"; 
}

print qq~
<tr><td valign=top><b>INC-Pfade</b></td><td valign=top>&nbsp;&nbsp;=&gt;&nbsp;&nbsp;</td><td>
$inc</td></tr></table><br><table border=1 cellspacing=0 cellpadding=2 width=100%>
<tr bgcolor=#b6d5e3><td colspan=3><b>Installierte Perl-Module</b></td></tr>
~;


###
#Module laden

foreach my $path (@INC) {

	next if ($path =~ /^\./) ;
	find(\&perlmodules,$path) ;
}

@mods=sort {lc($a) cmp lc($b)} keys %MODS ;
my $amount=int($#mods/3+.9999) ;

for (my $mod=0 ; $mod<$amount ; $mod++)  {
	
	print qq(<tr><td width=33%>$mods[$mod]</td><td width=33%>$mods[$mod+1*$amount]</td><td width=33%>$mods[$mod+2*$amount]</td></tr>\n) ;
}

print "</table></body></html>" ;



###########################################################################
# Module laden
###########################################################################

sub perlmodules {	
	

if ($File::Find::name =~ /\.pm$/){		
		
	open(MODFILE,$File::Find::name) || return;		
	while(<MODFILE>){			
			
		if (/^ *package +(\S+);/) {				
			$MODS{$1}=1 ;	
			last;
		}
	}
	close(MODFILE) ;
}
	
	
}



###########################################################################
# ENDE
###########################################################################
